module.exports = {
    'env': {
        'browser': true,
        'es6': true,
        'commonjs': true,
        'mocha': true,
    },
    'extends': [
        'eslint:recommended',
    ],
    'parserOptions': {
        'parser': 'babel-eslint',
        'ecmaVersion': 2017,
        'sourceType': 'module',
    },
    'rules': {
        /*
         * General code formatting:
         * - 4 spaces
         * - singlequotes
         * - semicolons at end of line
         * - max line length of 120 characters
         * - dangling commas in multiline arrays & objects
         * - Spaces
         *    - In inline objects
         *    - In inline arrays
         *    - In import statements
         *    - Around arrow in arrow functions
         *    - Around operators
         *    - At beginning of comments
         *    - In single line block
         * - Absolutely no usage of `window.alert`
         * - No usage of the `var` keyword.
         */
        'indent': [ 'error',  4,  { 'SwitchCase': 1 }],
        'no-tabs': 'error',
        'linebreak-style': [ 'error',  'unix' ],
        'quotes': [ 'error', 'single' ],
        'prefer-template': 'error',
        'semi': [ 'error',  'always' ],
        'comma-dangle': [ 'error',  'always-multiline' ],
        'no-trailing-spaces': 'error',
        'array-bracket-spacing': [ 'error', 'always', { 'objectsInArrays': false, 'arraysInArrays': false }],
        'object-curly-spacing': [ 'error', 'always', { 'arraysInObjects': false, 'objectsInObjects': false }],
        'space-in-parens': [ 'error', 'never' ],
        'space-infix-ops': 'error',
        'space-unary-ops': [ 'error', { 'words': true, 'nonwords': false }],
        'spaced-comment': [ 'error', 'always', { 'block': { 'balanced': true }}],
        'block-spacing': [ 'error', 'always' ],
        'switch-colon-spacing': [ 'error', { 'after': true, 'before': false }],
        'arrow-spacing': [ 'warn', { 'before': true, 'after': true }],
        'no-alert': 'error',
        'no-var': 'error',

        /*
         * Security:
         * - No usage of `eval()`
         */
        'no-eval': 'error',


        /*
         * Bug prevention:
         * - No monkeypatching by modifying `prototype`
         * - Extending classes must call super constructor
         * - Usage of `await` in loops
         * - No usage of non-ASCII class or function names
         * - No usage of `throw 'string'`
         * - Enforce radix parameter for `parseInt`
         * - No shadowing variable declarations
         * - No chained assignments
         * - No nested ternaries ( foo ? bar : baz ? baz : null )
         */
        'no-prototype-builtins': 'warn',
        'no-proto': 'warn',
        'no-await-in-loop': 'warn',
        'no-misleading-character-class': 'warn',
        'no-throw-literal': 'error',
        'radix': 'warn',
        'no-shadow': 'warn',
        'no-multi-assign': 'warn',
        'no-nested-ternary': 'warn',

        /*
         * Code Quality indicators:
         * - Cyclomatic complexity limit
         * - Nesting depth limit
         * - Maximum number of lines per file
         * - Maximum number of params per method
         * - Maximum number of statements per method
         * - No console.log
         * - No duplicate imports
         */
        'max-len': [ 'warn', { 'code': 120 }],
        'max-depth': [ 'warn', 3 ],
        'max-lines': [ 'warn', 500 ],
        'max-nested-callbacks': [ 'warn', 3 ],
        'max-params': [ 'warn', 4 ],
        'max-statements': [ 'warn', 30 ],
        'no-duplicate-imports': 'error',
        'no-console': [
            'warn', {
                'allow': [ 'info', 'warn', 'error' ],
            },
        ],
    },

    /*
     * The `process` global provides information about build details (such as the
     * current bundles hash) when in a webpack environment.
     */
    'globals': {
        'process': false,
    },
};
