# Set app server to 'nginx' by default. This leads to skipping .htaccess
# and .htpasswd files, as they're apache2-specific.
set :app_server, 'nginx'

# Deploy via remote cache; This fetches everything from git directly instead
# of uploading the whole project, e.g. by using rsync.
set :deploy_via, :remote_cache

# Allow key forwarding via SSH agent. This is required for
# continuous deployment to allow public key authentication.
set :ssh_options, forward_agent: true

# Set default deployment directory to user home. Each environment
# has its own user with its own user home.
set :deploy_to, '~/'

# Set releases to be kept to 2, as they may use around 600MB
# of disk space together with installed composer packages.
set :keep_releases, 2

set :linked_dirs, fetch(:linked_dirs, []).push(
  'htdocs/fileadmin',
  'htdocs/uploads'
)

ask :branch, `git rev-parse --abbrev-ref HEAD`.chomp

if fetch(:app_server) == 'apache2'
  set :linked_files, fetch(:linked_files, []).push(
    'htdocs/.htaccess',
    'htdocs/.htpasswd'
  )
end

run_locally do
  if ::File.exist? '.env'
    set :linked_files, fetch(:linked_files, []).push('.env')
  else
    set :linked_files, fetch(:linked_files, []).push(
      'htdocs/typo3conf/AdditionalConfiguration.php'
    )
  end
end

before 'deploy:publishing', 'composer:install'
before 'deploy:publishing', 'create_directories:typo3'
after 'deploy:publishing', 'typo3:clear_caches'
