#
# Symlink tasks.
#
# Overwrites the default capistrano task with ones
# that creates relative symlinks
#

require "pathname"

Rake::Task["deploy:symlink:release"].clear
Rake::Task["deploy:symlink:linked_files"].clear
Rake::Task["deploy:symlink:linked_dirs"].clear

namespace :deploy do
  namespace :symlink do
    desc 'Create a relative symlink from release to current folder'
    task :release do
      on release_roles :all do
        within fetch(:deploy_to) do
          execute :rm, '-f', 'current'
          execute :ln, '-s', "releases/#{File.basename(release_path)}", 'current'
        end
      end
    end

    desc 'Symlink linked directories'
    task :linked_dirs do
      next unless any? :linked_dirs
      on release_roles :all do
        execute :mkdir, '-p', linked_dir_parents(release_path)
        fetch(:linked_dirs).each do |dir|
          target = release_path.join(dir)
          source = shared_path.join(dir)
          within(target.parent) do
            if test "[ -d #{target} ]"
              execute :rm, "-rf", target
            end
            rel = source.relative_path_from target.parent
            execute :ln, "-s", rel
          end
        end
      end
    end

    desc 'Symlink linked files'
    task :linked_files do
      next unless any? :linked_files
      on release_roles :all do
        execute :mkdir, '-p', linked_file_dirs(release_path)
        fetch(:linked_files).each do |file|
          target = release_path.join(file)
          source = shared_path.join(file)
          within(target.parent) do
            unless test "[ -L #{target} ]"
              if test "[ -f #{target} ]"
                execute :rm, target
              end
              rel = source.relative_path_from target.parent
              execute :ln, '-s', rel
            end
          end
        end
      end
    end
  end
end
