# frozen_string_literal: true

#
# Neos specific tasks.
#

namespace :neos do
  #
  # Flush caches to prevent wrong class
  # caching information after deployments.
  #
  task :flush_caches do
    on release_roles :all do
      within release_path do
        # Flush Flow Framework cache.
        execute :php, 'flow', 'flow:cache:flush'

        # Flush PHP's opcache.
        execute 'php -r "opcache_reset();"'
      end
    end
  end

  #
  # Create missing child nodes that may be introduced by
  # updating node type configurations with new `children`.
  #
  task :create_missing_child_nodes do
    on release_roles :all do
      within release_path do
        execute :php, 'flow', 'node:repair --only createMissingChildNodes'
      end
    end
  end

  #
  # Publishes neos resources in order to have assets available.
  #
  task :publish_resources do
    on release_roles :all do
      within release_path do
        execute :php, 'flow', 'resource:publish'
      end
    end
  end

  #
  # Warm up caches for a quicker start after deployment.
  #
  task :warm_caches do
    on release_roles :all do
      within release_path do
        execute :php, 'flow', 'cache:warmup'
      end
    end
  end

  #
  # Run database migrations.
  #
  task :migrate_database do
    on release_roles :all do
      within release_path do
        execute :php, 'flow', 'doctrine:migrate'
      end
    end
  end
end
