# frozen_string_literal: true

# Set app server to 'nginx' by default. This leads to skipping .htaccess
# and .htpasswd files, as they're apache2-specific.
set :app_server, 'nginx'

# Deploy via remote cache; This fetches everything from git directly instead
# of uploading the whole project, e.g. by using rsync.
set :deploy_via, :remote_cache

# Allow key forwarding via SSH agent. This is required for
# continuous deployment to allow public key authentication.
set :ssh_options, forward_agent: true

# Set default deployment directory to user home. Each environment
# has its own user with its own user home.
set :deploy_to, '~/'

# Set releases to be kept to 2, as they may use around 600MB
# of disk space together with installed composer packages.
set :keep_releases, 2

set :linked_dirs, fetch(:linked_dirs, []).push(
  'Configuration/Production',
  'Data/Persistent'
)

ask :branch, `git rev-parse --abbrev-ref HEAD`.chomp

if fetch(:app_server) == 'apache2'
  set :linked_files, fetch(:linked_files, []).push(
    'Web/.htaccess',
    'Web/.htpasswd'
  )
end

before 'deploy:publishing', 'composer:install'
before 'deploy:publishing', 'neos:migrate_database'
before 'deploy:publishing', 'neos:create_missing_child_nodes'
before 'deploy:publishing', 'neos:flush_caches'
before 'deploy:publishing', 'neos:publish_resources'
before 'deploy:publishing', 'neos:warm_caches'
