const foo = 'bar';

function doSomething() {

}

// All of the statements below are now invalid

// switch/case must be indented
switch (foo) {
case 'bar':
    doSomething();
    break;
}

// Blocks must use braces
if (foo) doSomething();
if (foo)
    doSomething();


// "one true brace style" is enforced
// The correct version of the following statements would be:
// if (foo) {
//     doSomething();   
// }
if (foo)
{ doSomething(); }

if (foo) {
    doSomething(); }

if (foo)
{ doSomething();
}

// Arrays must have spaces around `[` and `]`
const bar = [1, 2, 3];

// unnecesarry ternaries are disallowed
const baz = foo === 'bar' ? true : false;

// template curly braces in non-template strings
const test = 'Hello ${foo}';

// Methods must now either always or never return
function onlySometimesReturns() {
    if (Math.random() < .5) {
        return true;
    }
}

// prototype extensions
Array.prototype.min = function() {
    return Math.min(...this);
};

// Implied `eval`
setTimeout('window.alert("hello")');
setInterval('window.alert("hello")');

// Unnecesarry nested blocks
{
    doSomething();
}

// No yoda
if ('bar' === foo) {
    doSomething();
}

// Variables must be camel cased
const test_variable = 'test';

/*
 This is a multiline comment without leading stars
 */

/**
    This is a docblock without leading stars
 */
