module.exports = {
    'env': {
        'browser': true,
        'es6': true,
        'commonjs': true,
        'mocha': true,
    },
    'extends': [
        'eslint:recommended',
    ],
    'parser': 'babel-eslint',
    'parserOptions': {
        'ecmaVersion': 2017,
        'sourceType': 'module',
    },
    'rules': {
        /*
         * General code formatting:
         * - 4 spaces
         * - singlequotes
         * - semicolons at end of line
         * - max line length of 120 characters
         * - require braces for while / for / if / else
         * - braces must start on same line as statement and end on it's own line (aka "one true brace style")
         * - dangling commas in multiline arrays & objects
         * - Spaces
         *    - In inline objects
         *    - In inline arrays
         *    - In import statements
         *    - Around arrow in arrow functions
         *    - Around operators
         *    - At beginning of comments
         *    - In single line block
         * - Absolutely no usage of `window.alert`
         * - No usage of the `var` keyword.
         * - No unnecessary nested blocks
         * - No yoda
         * - Camel case
         * - Consistent multiline comments
         */
        'indent': [ 'error',  4,  { 'SwitchCase': 1 }],
        'no-tabs': 'error',
        'linebreak-style': [ 'error',  'unix' ],
        'quotes': [ 'error', 'single' ],
        'prefer-template': 'error',
        'semi': [ 'error',  'always' ],
        'max-len': [ 'warn', { 'code': 120 }],
        'curly': [ 'warn', 'all' ],
        'brace-style': [ 'warn', '1tbs' ],
        'comma-dangle': [ 'error',  'always-multiline' ],
        'no-trailing-spaces': 'error',
        'object-curly-spacing': [ 'error', 'always'],
        'array-bracket-spacing': [ 'warn', 'always'],
        'space-in-parens': [ 'error', 'never' ],
        'space-infix-ops': 'error',
        'space-unary-ops': [ 'error', { 'words': true, 'nonwords': false }],
        'spaced-comment': [ 'error', 'always', { 'block': { 'balanced': true }}],
        'block-spacing': [ 'error', 'always' ],
        'switch-colon-spacing': [ 'error', { 'after': true, 'before': false }],
        'arrow-spacing': [ 'warn', { 'before': true, 'after': true }],
        'no-alert': 'error',
        'no-var': 'error',
        'no-extend-native': 'error',
        'no-lone-blocks': 'error',
        'yoda': 'warn',
        'camelcase': 'error',
        'prefer-template': 'warn',
        'multiline-comment-style': [ 'warn', 'starred-block' ],

        /*
         * Security:
         * - No usage of `eval()`
         */
        'no-eval': 'error',
        'no-implied-eval': 'error',


        /*
         * Bug prevention:
         * - No monkeypatching by modifying `prototype`
         * - Extending classes must call super constructor
         * - Usage of `await` in loops
         * - No usage of non-ASCII class or function names
         * - No usage of `throw 'string'`
         * - Enforce radix parameter for `parseInt`
         * - No shadowing variable declarations
         * - No chained assignments
         * - No nested ternaries ( foo ? bar : baz ? baz : null )
         * - Template string braces in non-template string
         * - Methods must either always or never return
         */
        'no-prototype-builtins': 'warn',
        'no-proto': 'warn',
        'no-await-in-loop': 'warn',
        'no-misleading-character-class': 'warn',
        'no-throw-literal': 'error',
        'radix': 'warn',
        'no-shadow': 'warn',
        'no-multi-assign': 'warn',
        'no-nested-ternary': 'warn',
        'no-unneeded-ternary': 'warn',
        'no-template-curly-in-string': 'warn',
        'no-unreachable-loop': 'warn',
        'consistent-return': 'warn',

        /*
         * Code Quality indicators:
         * - Cyclomatic complexity limit
         * - Nesting depth limit
         * - Maximum number of lines per file
         * - Maximum number of params per method
         * - Maximum number of statements per method
         * - No console.log
         * - No duplicate imports
         */
        'max-depth': [ 'warn', 3 ],
        'max-lines': [ 'warn', 500 ],
        'max-nested-callbacks': [ 'warn', 3 ],
        'max-params': [ 'warn', 4 ],
        'max-statements': [ 'warn', 30 ],
        'no-duplicate-imports': 'error',
        'no-console': [
            'warn', {
                'allow': [ 'info', 'warn', 'error' ],
            },
        ],
    },

    /*
     * The `process` global provides information about build details (such as the
     * current bundles hash) when in a webpack environment.
     */
    'globals': {
        'process': false,
    },
};
