#
# Neos specific tasks.
#

namespace :neos do
  #
  # Flush caches to prevent wrong class
  # caching information after deployments.
  #
  task :flush_caches do
    on release_roles :all do
      within release_path do
        # Flush Flow Framework cache.
        execute :php, 'flow', 'flow:cache:flush'

        # Flush PHP's opcache.
        execute 'php -r "opcache_reset();"'
      end
    end
  end

  #
  # Publishes neos resources in order to have assets available.
  #
  task :publish_resources do
    on release_roles :all do
      within release_path do
        execute :php, 'flow', 'resource:publish'
      end
    end
  end

  #
  # Warm up caches for a quicker start after deployment.
  #
  task :warm_caches do
    on release_roles :all do
      within release_path do
        execute :php, 'flow', 'cache:warmup'
      end
    end
  end

  #
  # Run database migrations.
  #
  task :migrate_database do
    on release_roles :all do
      within release_path do
        execute :php, 'flow', 'doctrine:migrate'
      end
    end
  end

  task :lock_release do
    on release_roles :all do
      within release_path do
        execute :php, 'flow', 'lock:release'
      end
    end
  end

  task :node_repair do
    on release_roles :all do
      within release_path do
        execute :php, 'flow', 'node:repair'
        execute :php, 'flow', 'cache:flush'
      end
    end
  end

  task :articles_synchronize do
    on release_roles :all do
      within release_path do
        execute :php, 'flow', 'articles:synchronize'
      end
    end
  end

  task :events_synchronize do
    on release_roles :all do
      within release_path do
        execute :php, 'flow', 'events:synchronize'
      end
    end
  end

  task :indexer_run do
    on release_roles :all do
      within release_path do
        execute :php, 'flow', 'indexer:run'
      end
    end
  end

end
