<?php declare(strict_types=1);

namespace NIMIUS\Graphing;

/**
 * Represents a data series that is used to build line graphs.
 */
class Series
{

    /**
     * Points as a multidimensional array of data.
     * These points are assumed to be in order.
     *
     * @var array
     */
    protected $points = [];

    /**
     * The data bounds in x direction as an array of [ min, max ].
     *
     * @var array
     */
    protected $xBounds = [ 999999999, 0 ];


    /**
     * The data bounds in y direction as an array of [ min, max ].
     *
     * @var array
     */
    protected $yBounds = [ 999999999, 0 ];

    /**
     * Adds a new point.
     *
     * @param float $x
     * @param float $y
     */
    public function addPoint(float $x, float $y): void
    {
        $this->points[] = [ $x, $y ];

        // Update x bounds
        if ($x < $this->xBounds[0]) {
            $this->xBounds[0] = $x;
        }
        if ($x > $this->xBounds[1]) {
            $this->xBounds[1] = $x;
        }

        // Update y bounds.
        if ($y < $this->yBounds[0]) {
            $this->yBounds[0] = $y;
        }
        if ($y > $this->yBounds[1]) {
            $this->yBounds[1] = $y;
        }
    }

    public function getPoints(): array
    {
        return $this->points;
    }

    /**
     * Returns the bounds on the X axis as an array of
     * [ minimum, maximum ][
     */
    public function xBounds(): array
    {
        return $this->xBounds;
    }

    /**
     * Returns the bounds on the Y axis as an array of
     * [ minimum, maximum ]
     */
    public function yBounds(): array
    {
        return $this->yBounds;
    }
}
