<?php declare(strict_types=1);

namespace NIMIUS\Graphing\Graph;

use NIMIUS\Graphing\Canvas\Drawable;
use NIMIUS\Graphing\Canvas\Drawer;
use NIMIUS\Graphing\Color;

class DebugRect implements Drawable
{

    public function draw(Drawer $drawer): void
    {
        $drawer->strokedPolygon([ [ 0, 0 ], [ 0, 100 ], [ 100, 100 ], [ 100, 0 ] ], Color::hex('#ff000055'));

        $drawer->line([ 0, 50 ], [ 100, 50 ], Color::hex('#00ff0055'), 3);
        $drawer->filledPolygon([ [ 90, 40 ], [ 100, 50 ], [ 90, 60 ] ], Color::hex('#00ff0055'));

        $drawer->line([ 50, 0 ], [ 50, 100 ], Color::hex('#0000ff55'), 3);
        $drawer->filledPolygon([ [ 40, 90 ], [ 50, 100 ], [ 60, 90 ] ], Color::hex('#0000ff55'));
    }

    public function drawableSize(array $sizeLeftInImage): array
    {
        return $sizeLeftInImage;
    }
}
