<?php declare(strict_types=1);

namespace NIMIUS\Graphing\Canvas;

interface Drawable
{

    /**
     * Draws the drawable using the given drawer.
     * This method applies the correct drawing instructions
     * in order for the current object to be visible on screen.
     *
     * @param Drawer $drawer
     */
    public function draw(Drawer $drawer);

    /**
     * Returns an array of how large the drawable thinks itself is.
     * These sizes will be used if no explicit size has been specified.
     *
     * The returned size must be an array of [ width, height ].
     *
     * @param array $sizeLeftInImage - The size that is left in the image.
     *                                 This should be the maximum size.
     * @return array
     */
    public function drawableSize(array $sizeLeftInImage): array;
}
