<?php declare(strict_types = 1);

namespace NIMIUS\Graphing\Graph\Behaviour;

use NIMIUS\Graphing\Canvas\Drawable;
use NIMIUS\Graphing\Canvas\Drawer;
use NIMIUS\Graphing\Color;
use NIMIUS\Graphing\Direction;

class Ticks extends AbstractAxis implements Drawable
{
    /** @var Color */
    protected $color;

    public function __construct(array $dataBounds, string $direction, int $numberOfTicks = 10, Color $color = null)
    {
        parent::__construct($dataBounds, $direction, $numberOfTicks);
        $this->color = $color ?? Color::hex('#000000');
    }

    public function draw(Drawer $drawer): void
    {
        foreach ($this->getTickPositions() as [ $x, $y, $label ]) {
            if ($this->direction === Direction::HORIZONTAL) {
                $drawer->line([ $x, 0 ], [ $x, 100 ], $this->color);
            } else {
                $drawer->line([ 0, $y ], [ 100, $y ], $this->color);
            }
        }
    }
}
