<?php declare(strict_types = 1);

namespace NIMIUS\Graphing\Graph\Behaviour;

use NIMIUS\Graphing\Canvas\Drawable;
use NIMIUS\Graphing\Canvas\Drawer;
use NIMIUS\Graphing\Color;

class TickLabels extends AbstractAxis implements Drawable
{
    /** @var Color */
    protected $color;

    /** @var array */
    protected $configuration = [
        Drawer::FONT_SIZE => 100,
        Drawer::TEXT_ALIGN => Drawer::TEXT_ALIGN_CENTER,
        Drawer::VERTICAL_ALIGN => Drawer::VERTICAL_ALIGN_CENTER,
    ];

    public function __construct(array $dataBounds, string $direction, int $numberOfTicks = 10, Color $color = null, array $configuration = [])
    {
        parent::__construct($dataBounds, $direction, $numberOfTicks);
        $this->color = $color ?? Color::hex('#000000');
        $this->configuration = array_replace($this->configuration, $configuration);
    }

    public function draw(Drawer $drawer): void
    {
        foreach ($this->getTickPositions() as [ $x, $y, $label ]) {
            $drawer->text($label, [ $x, $y ], $this->color, $this->configuration);
        }
    }
}
