<?php declare(strict_types = 1);

namespace NIMIUS\Graphing\Graph\Behaviour;

use NIMIUS\Graphing\Canvas\Drawable;
use NIMIUS\Graphing\Canvas\Drawer;
use NIMIUS\Graphing\Color;
use NIMIUS\Graphing\Direction;

class DashedLine implements Drawable
{
    /** @var string */
    protected $direction;

    /** @var float */
    protected $dashLength;

    /** @var float */
    protected $gapLength;

    /** @var Color */
    protected $color;

    public function __construct(string $direction, float $dashLength = 5, float $gapLength = 5, Color $color = null)
    {
        $this->direction = $direction;
        $this->dashLength = $dashLength;
        $this->gapLength = $gapLength;
        $this->color = $color ?? Color::hex('#000000');
    }

    public function draw(Drawer $drawer)
    {
        $position = 0;
        while ($position < 100) {
            if ($this->direction === Direction::HORIZONTAL) {
                $drawer->line([ $position, 0 ], [ $position + $this->dashLength, 0 ], $this->color);
            } else {
                $drawer->line([ 0, $position ], [ 0, $position + $this->dashLength], $this->color);
            }
            $position += $this->dashLength + $this->gapLength;
        }
    }

    public function drawableSize(array $sizeLeftInImage): array
    {
        return $sizeLeftInImage;
    }
}
