// Fix for Webpack 4+ + Node 17+ (OpenSSL 3)
const crypto = require('crypto');
try {
    crypto.createHash('md4');
} catch (err) {
    const origCreateHash = crypto.createHash;
    crypto.createHash = (alg, opts) => origCreateHash(alg === 'md4' ? 'sha256' : alg, opts);
}

const config = require('./webpack.base.config')(false);
const VueSSRServerPlugin = require('vue-server-renderer/server-plugin');

// This allows webpack to handle dynamic imports in a Node-appropriate
// fashion, and also tells `vue-loader` to emit server-oriented code when
// compiling Vue components.
config.target = 'node';

// This tells the server bundle to use Node-style exports
config.output.libraryTarget = 'commonjs2';

// This is the plugin that turns the entire output of the server build
// into a single JSON file. The default file name will be
// `vue-ssr-server-bundle.json`
config.plugins.push(new VueSSRServerPlugin());

module.exports = config;
