// Fix for Webpack 4+ + Node 17+ (OpenSSL 3)
const crypto = require('crypto');
try {
    crypto.createHash('md4');
} catch (err) {
    const origCreateHash = crypto.createHash;
    crypto.createHash = (alg, opts) => origCreateHash(alg === 'md4' ? 'sha256' : alg, opts);
}

module.exports = {
    mode: 'none',
    target: 'node',

    output: {
        filename: 'ssr-cli.bundle.js',
    },

    resolve: {
        alias: {
            '%%TOUBIZ_WIDGET_TAILWIND_CONFIG%%': process.env.TAILWIND_CONFIG,
        },
    },
};
