<?php declare(strict_types=1);

namespace Newland\ToubizWidgetRendering\Controller;

use Neos\Flow\Mvc\Controller\ActionController;
use Newland\ToubizWidgetRendering\Exception\InvalidParameterException;
use Neos\Flow\Annotations as Flow;
use Newland\ToubizWidgetRendering\Service\WidgetPageService;
use Ramsey\Uuid\Uuid;

class RedirectController extends ActionController
{
    /**
     * @var array
     * @Flow\InjectConfiguration(path="redirect")
     */
    protected $configuration;
    /**
     * @var WidgetPageService
     * @Flow\Inject()
     */
    protected $widgetPageService;

    public function widgetDetailAction(string $type, string $language, string $uuid): void
    {
        $this->validateUuid($uuid);

        $widgetPageNode = $this->widgetPageService->getWidgetPageNode($language);
        $basePath = $this->uriBuilder
            ->reset()
            ->setCreateAbsoluteUri(true)
            ->uriFor('show', [ 'node' => $widgetPageNode ], 'Frontend\Node', 'Neos.Neos');

        $this->redirectToUri(
            sprintf('%s#/%s/%s', $basePath, $this->getType($type), $uuid),
            0,
            301
        );
    }

    private function getType(string $parameter): string
    {
        $type = $this->configuration['types'][$parameter] ?? null;

        if ($type === null) {
            throw new InvalidParameterException(sprintf('No type mapping configured for parameter "%s"', $parameter));
        }

        return $type;
    }

    private function validateUuid(string $uuid): void
    {
        if (Uuid::isValid($uuid) === false) {
            throw new InvalidParameterException(sprintf('"%s" is not a valid uuid.', $uuid));
        }
    }
}
