const path = require('path');
const purgecss = require('@fullhuman/postcss-purgecss');

module.exports = () => {
    const env = process.env.NODE_ENV || 'development';
    const prod = env === 'production';

    const config = {
        plugins: [
            require('postcss-import'),
            require('tailwindcss')(process.env.TAILWIND_CONFIG),
            require('autoprefixer'),
        ],
    };

    if (prod) {
        config.plugins.push(
            purgecss({
                content: [
                    path.resolve(__dirname, 'node_modules/@newland/**/*.vue'),
                    path.resolve(__dirname, 'node_modules/v-calendar/src/**/*.vue'),
                ],
                extractors: [
                    {
                        extractor: content => content.match(/[\w-/.:]+(?<!:)/g) || [],
                        extensions: [ 'scss', 'sass', 'css', 'vue', 'md' ],
                    },
                ],
                whitelistPatterns: [ /^redactor-/, /^re-/, /^mtk-/, /^gap-/, /^grid-cols-/, /^tb-w/, /^flatpickr-/, /data-v-.*/, /^::v-deep/,
                    /^swiper-/, /^mapbox/, /^mgl-/ ],
                whitelist: [ 'visually-hidden', 'sr-only', 'bg-alert', 'bg-gray-400', 'dayContainer' ],
            }),
        );
    }


    return config;
};
