const config = require('./webpack.base.config')(false);
const VueSSRServerPlugin = require('vue-server-renderer/server-plugin');

// This allows webpack to handle dynamic imports in a Node-appropriate
// fashion, and also tells `vue-loader` to emit server-oriented code when
// compiling Vue components.
config.target = 'node';

// This tells the server bundle to use Node-style exports
config.output.libraryTarget = 'commonjs2';

// This is the plugin that turns the entire output of the server build
// into a single JSON file. The default file name will be
// `vue-ssr-server-bundle.json`
config.plugins.push(new VueSSRServerPlugin());

module.exports = config;
