<?php declare(strict_types=1);

namespace Newland\ToubizWidgetRendering\Utility;

use Symfony\Component\Console\Formatter\OutputFormatterInterface;
use Symfony\Component\Console\Output\OutputInterface;

class PrefixedOutput implements OutputInterface
{
    /** @var string */
    private $prefix;

    /** @var OutputInterface */
    private $output;

    public function __construct(string $prefix, OutputInterface $output)
    {
        $this->prefix = $prefix;
        $this->output = $output;
    }

    /**
     * @param string|string[] $messages
     * @return string[]
     */
    private function prefix($messages): array
    {
        return array_map(function ($message) {
            return $this->prefix . $message;
        }, (array) $messages);
    }

    public function write($messages, $newline = false, $options = 0): void
    {
        $this->output->write($this->prefix($messages), $newline, $options);
    }

    public function writeln($messages, $options = 0): void
    {
        $this->output->writeln($this->prefix($messages), $options);
    }

    public function setVerbosity($level): void
    {
        $this->output->setVerbosity($level);
    }

    public function getVerbosity()
    {
        return $this->output->getVerbosity();
    }

    public function isQuiet()
    {
        return $this->output->isQuiet();
    }

    public function isVerbose()
    {
        return $this->output->isVerbose();
    }

    public function isVeryVerbose()
    {
        return $this->output->isVeryVerbose();
    }

    public function isDebug()
    {
        return $this->output->isDebug();
    }

    public function setDecorated($decorated): void
    {
        $this->output->setDecorated($decorated);
    }

    public function isDecorated()
    {
        return $this->output->isDecorated();
    }

    public function setFormatter(OutputFormatterInterface $formatter): void
    {
        $this->output->setFormatter($formatter);
    }

    public function getFormatter()
    {
        return $this->output->getFormatter();
    }
}
