<?php declare(strict_types=1);

namespace Newland\ToubizWidgetRendering\Tests\Unit\Utility;

use Neos\Flow\Tests\FunctionalTestCase;
use Newland\ToubizWidgetRendering\Utility\HtmlUtility;

class HtmlUtilityTest extends FunctionalTestCase
{

    /** @var HtmlUtility */
    protected $subject;

    public function setUp(): void
    {
        parent::setUp();
        $this->subject = $this->objectManager->get(HtmlUtility::class);
    }

    public function testBuildsHtmlTag(): void
    {
        $this->assertEquals('<p></p>', $this->subject->build('p'));
    }

    public function testBuildsHtmlTagWithContent(): void
    {
        $this->assertEquals('<p>Hello World</p>', $this->subject->build('p', [ ], [ 'Hello World' ]));
    }

    public function testBuildsHtmlTagWithMultipleContents(): void
    {
        $content = $this->subject->build('p', [ ], [ 'Hello', 'World' ]);
        $this->assertStringContainsString('Hello', $content);
        $this->assertStringContainsString('World', $content);
    }

    public function testAddsAttributes(): void
    {
        $this->assertEquals(
            '<p class="test">Test</p>',
            $this->subject->build('p', [ 'class' => 'test' ], [ 'Test' ])
        );
    }

    public function testDotsInAttributeNamesArePermitted(): void
    {
        $this->assertEquals(
            '<p foo.bar="baz">Test</p>',
            $this->subject->build('p', [ 'foo.bar' => 'baz' ], [ 'Test' ])
        );
    }

    public function testQuotesInAttributesAreEscaped(): void
    {
        $this->assertEquals(
            '<p foo.bar="{&quot;baz&quot;:&quot;test&quot;}">Test</p>',
            $this->subject->build('p', [ 'foo.bar' => json_encode([ 'baz' => 'test' ]) ], [ 'Test' ])
        );
    }

    public function testVueAttributesArePassedAsJsonEncodedProps(): void
    {
        $this->assertEquals(
            '<my-component :int="3" :string="&quot;test&quot;"></my-component>',
            $this->subject->buildVue('my-component', [ 'int' => 3, 'string' => 'test' ])
        );
    }

}
