# Toubiz Widget Rendering

A package that provides classes in order to adapt the toubiz widget rendering
to PHP.

## Usage
### Configuration
For configuration reference, check [Settings.yaml](./Configuration/Settings.yaml)

While most settings should have a sensible default, you need to set a valid API token
for every project.

### Widget Integration
For imported records SSR should be the default behavior. SSR will render links to all records -
including those that might _not_ be imported. If a link like that is called then Neos will redirect
to the widget. Any subsequent errors will hopefully be caught by the widget.

Examples: 
- a collection on an area detail page
- an item in a collection from a foreign client

#### The widget page
Make sure to create a **widget page**. Just create a blank page with a neutral title (like "Content")
and place the widget plugin on it. Set the identifier of that node in the settings:
```
Newland:
  ToubizWidgetRendering:
    redirect:
      node: '558735ae-a292-4d43-a8e6-aafdad3b2057'
```

#### Multi language support
If your project supports multiple languages then you need to save a variant of the **widget page**
in every language. Make sure this an actual variant and not a new, unrelated page:
1. visit the widget page in the default language
2. change the language selector
3. select "create and copy"
4. publish your changes

#### Routes
To support automatic redirecting you also need to add the routes of this package to the `Routes.yaml`
of your project:
```
-
  name: 'ToubizWidgetRendering'
  uriPattern: '<ToubizWidgetRenderingSubroutes>'
  subRoutes:
    'ToubizWidgetRenderingSubroutes':
      package: 'Newland.ToubizWidgetRendering'
```

### Workflow
The server side rendering workflow consists of 2 stages:
* precompilation: Prepares / compiles the files needed for server side rendering
  during development time. This can be achieved by using the `php flow toubizWidget:precompile`
  command. The resulting files (Default: `Web/_ToubizWidget`) should be included in the repository
  and deployed with the website.
* rendering: Happens during request time on the server and thanks to the precompilation step does
  not require installing external dependencies. Everything that is required for rendering the
  widget should have been created during `php flow toubizWidget:precompile`.

## Debugging

With every run of `toubizWidget:precompile`, `yarn install` is being run in order to
ensure, that node_modules are up to date. This means that all changes in node_modules
will be reset with every run of `toubizWidget:precompile`.

For debugging purposes it may be necessary to change components in node_modules (e.g. to
find where an error in toubiz-widget is coming from). For these instances you can set 
`yarnInstall` to `false` in settings.

## Development

Whenever something about the output javascript changes, the `toubizWidget:compileStaticFallback`
command should be run in order to compile the static fallback that serves as a last-ditch fallback
instead of displaying nothing. These should then be committed in the neos-toubiz-frontend repository
in order to statically have them exist in every installation.
