// Fix for Webpack 4+ + Node 17+ (OpenSSL 3)
const crypto = require('crypto');
try {
    crypto.createHash('md4');
} catch (err) {
    const origCreateHash = crypto.createHash;
    crypto.createHash = (alg, opts) => origCreateHash(alg === 'md4' ? 'sha256' : alg, opts);
}

const config = require('./webpack.base.config')(true);

config.output.filename = 'entry-client.bundle.js';

module.exports = config;
