import { initializeToubizWidgetVueApp } from './initialize-app';

function initializeClientOnlyRendering(element) {
    initializeToubizWidgetVueApp().then(app => app.$mount(element));
}

function initializeClientSideOfSsr(element, id) {
    const templateTag = document.querySelector(`[data-toubiz-widget-rendering\\.template="${id}"]`);
    const template = templateTag.innerHTML;

    initializeToubizWidgetVueApp(template).then(app => app.$mount(element, true));
}

function initialize(element) {
    const ssrId = element.getAttribute('data-toubiz-widget-rendering.ssr');
    if (ssrId) {
        initializeClientSideOfSsr(element, ssrId)
    } else {
        initializeClientOnlyRendering(element);
    }
}

for (const element of document.querySelectorAll('[data-toubiz-widget-rendering]')) {
    initialize(element);
}
