<?php declare(strict_types=1);

namespace Newland\ToubizWidgetRendering\ViewHelpers;

use Neos\Flow\Annotations as Flow;
use Newland\ToubizWidgetRendering\Renderer\ToubizWidgetRenderer;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;

class RenderComponentViewHelper extends AbstractViewHelper
{
    /**
     * @var ToubizWidgetRenderer
     * @Flow\Inject
     */
    protected $widgetRenderer;

    public function initializeArguments(): void
    {
        $this->registerArgument('component', 'string', 'The name of the Vue component', true);
        $this->registerArgument(
            'props',
            'array',
            'The props passed into the component',
            false,
            []
        );
    }

    public function render(): string
    {
        return $this->widgetRenderer->render($this->arguments['component'], $this->arguments['props']);
    }
}
