import TbContentAreaUsageInstructions from './tb-content-area-usage-instructions';
import registryProxy from './component-registry';

export async function initializeToubizWidgetVueApp(template = null) {
    const [ Vue, ToubizWidget ] = await Promise.all([
        import('vue').then(mod => mod.default),
        import('@newland/toubiz-widget').then(mod => mod.default),
    ]);

    Vue.use(ToubizWidget, {
        initializeRouter: () => null,
        registerLinkGenerators (registry) {
            registry.registerLinkGenerator('article.detail', (route) => `/redirect/article/${route.params.id}`);
            registry.registerLinkGenerator('article.list', (route) => `/redirect/articles?params=${route.query.params}`);
            registry.registerLinkGenerator('event.detail', (route) => `/redirect/event/${route.params.id}`);
            registry.registerLinkGenerator('event.list', (route) => `/redirect/events?params=${route.query.params}`);
        },
        componentRegistration(registry) {
            registryProxy.apply(registry);
            registry.replaceComponent('tb-content-area-usage-instructions', TbContentAreaUsageInstructions);
        },
        errorLoggerHints: [
            {
                check: () => process.env.NODE_ENV === 'production',
                hint: `
                    Check the \`buildMode\` setting of the \`serverSide\` renderer in the
                    \`Newland.ToubizWidgetRendering\` package in order to change the build mode to \`development\`.

                    Building the app in development mode may yield additional error information.
                `
            }
        ]
    });

    return new Vue({
        template,
        data: () => ({
            baseUri: process.env.TOUBIZ_BASE_URI,
        }),
    });
}
