# Toubiz Widget Rendering

A package that provides classes in order to adapt the toubiz widget rendering
to PHP.

## Usage
### Configuration
For configuration reference, check [Settings.yaml](./Configuration/Settings.yaml)

### Workflow
The server side rendering workflow consists of 2 stages:
* precompilation: Prepares / compiles the files needed for server side rendering
  during development time. This can be achieved by using the `php flow toubizWidget:precompile`
  command. The resulting files (Default: `Web/_ToubizWidget`) should be included in the repository
  and deployed with the website.
* rendering: Happens during request time on the server and thanks to the precompilation step does
  does not require installing external dependencies. Everything that is required for rendering the
  widget should created during `php flow toubizWidget:precompile`.

## Debugging

With every run of `toubizWidget:precompile`, `yarn install` is being run in order to
ensure, that node_modules are up to date. This means that all changes in node_modules
will be reset with every run of `toubizWidget:precompile`.

For debugging purposes it may be necessary to change components in node_modules (e.g. to
find where an error in toubiz-widget is coming from). For these instances you can set 
`yarnInstall` to `false` in settings.

## Development

Whenever something about the output javascript changes, the `toubizWidget:compileStaticFallback`
command should be run in order to compile the static fallback that serves as a last-ditch fallback
instead of displaying nothing. These should then be commited in the neos-toubiz-frontend repository
in order to statically have them exist in every installation.
