const VueServerRenderer = require('vue-server-renderer');

if (process.stdin.isTTY) {
    throw new Error(`
        The render command is expected to receive the raw template to render via STDIN. Please pipe some content
        to this command like this:

        $ echo '<p>Some content to render here</p>' | node ssr-cli.js [...]
    `);
}

render(
    process.env.TOUBIZ_WIDGET_SSR_BUNDLE,
    process.env.TOUBIZ_WIDGET_SSR_CLIENT_MANIFEST
).catch(error => {
    console.error(error);
    process.exit(1);
});

async function render(serverBundle, clientManifest) {

    const renderer = VueServerRenderer.createBundleRenderer(serverBundle, {
        runInNewContext: true,
        clientManifest: __non_webpack_require__(clientManifest),
    });
    const template = await readStdin();

    const context = { template };
    renderer.renderToString(context).then(html => {
        // Note: Using `process.stdout.write` instead of `console.log` because `console.log` will break down long lines.
        process.stdout.write(html);
        process.stdout.write(context.renderStyles());
        process.stdout.write(context.renderScripts());
        // process.stdout.write(context.renderResourceHints());
    }).catch(err => {
        console.error(err);
        process.exit(1);
    });
}

function readStdin() {
    return new Promise(resolve => {
        let stdin = '';
        process.stdin.on('data', data => stdin += data);
        process.stdin.on('end', () => resolve(stdin));
    });
}
