<?php

namespace Newland\Toubiz\Weather\Neos\Controller;

/*
 * This file is part of the "toubiz-weather-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\Flow\Annotations as Flow;
use Neos\Flow\Configuration\ConfigurationManager;
use Neos\Flow\Mvc\Controller\ActionController;
use Neos\Flow\Mvc\View\ViewInterface;
use Newland\Toubiz\Sync\Neos\Domain\Repository\WeatherRepository;
use Newland\Toubiz\Weather\Neos\Service\CopyrightService;

/**
 * Weathers controller.
 *
 * @Flow\Scope("singleton")
 */
class WeathersController extends ActionController
{
    /**
     * @var \Neos\ContentRepository\Domain\Model\Node
     */
    protected $node;

    /**
     * @var array
     */
    protected $properties = [];

    /**
     * @Flow\Inject
     * @var WeatherRepository
     */
    protected $weatherRepository;

    /**
     * @var CopyrightService
     * @Flow\Inject
     */
    protected $copyrightService;

    /**
     * Action initializer.
     *
     * @return void
     */
    public function initializeAction()
    {
        $this->node = $this->request->getInternalArgument('__node');
        $this->properties = (array) $this->node->getProperties();

        if ($this->request->getInternalArgument('__mode')) {
            $this->properties['mode'] = $this->request->getInternalArgument('__mode');
        }
        if ($this->request->getInternalArgument('__city')) {
            $this->properties['city'] = $this->request->getInternalArgument('__city');
        }
    }

    /**
     * View initializer.
     *
     * @param ViewInterface $view
     * @return void
     */
    public function initializeView(ViewInterface $view)
    {
        if ($this->request->getInternalArgument('__templatePath')) {
            $view->setTemplatePathAndFilename($this->request->getInternalArgument('__templatePath'));
        }

        $view->assignMultiple(
            [
                'node' => $this->node,
                'copyrightInfo' => $this->copyrightService->getCopyrightInfo(),
                'properties' => $this->properties,
            ]
        );
    }

    /**
     * Forecast action.
     *
     * Renders a Weather forecast for a given city.
     *
     * @return void
     */
    public function forecastAction()
    {
        if (!array_key_exists('city', $this->properties)) {
            return;
        }

        $weather = $this->weatherRepository->findByCity($this->properties['city']);
        $forecast = $weather ? $weather->getForecast() : [];

        $this->view->assignMultiple(
            [
                'forecast' => $forecast,
                'mode' => $this->properties['mode'],
            ]
        );
    }
}
