<?php
namespace Newland\Toubiz\Weather\Neos\Service;

/*
 * This file is part of the "toubiz-weather-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\Flow\Annotations as Flow;
use Neos\Flow\Configuration\ConfigurationManager;

class CopyrightService
{
    /**
     * @var ConfigurationManager
     * @Flow\Inject
     */
    protected $configurationManager;

    /**
     * While the data itself is provider-agnostic, we still need to display a copyright notice
     *
     * @return array
     */
    public function getCopyrightInfo(): array
    {
        $copyrightInfo = [
            'name' => '',
            'url' => '',
        ];

        /** @var string $dataProvider */
        $dataProvider = $this->configurationManager->getConfiguration(
            ConfigurationManager::CONFIGURATION_TYPE_SETTINGS,
            'Newland.Toubiz.Sync.Neos.dataProvider.weather'
        ) ?? '';

        $services = (array) $this->configurationManager->getConfiguration(
            ConfigurationManager::CONFIGURATION_TYPE_SETTINGS,
            'Newland.Toubiz.Weather.Neos.services'
        );

        if (array_key_exists($dataProvider, $services)) {
            $serviceConfiguration = $services[$dataProvider];
            $copyrightInfo = $serviceConfiguration['copyright'];
        }

        return $copyrightInfo;
    }
}
