<?php
namespace Newland\Toubiz\Weather\Neos\ViewHelpers\Widget;

/*
 * This file is part of the "toubiz-weather-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\ContentRepository\Domain\Model\NodeInterface;
use Neos\Flow\Annotations as Flow;
use Newland\NeosCommon\ViewHelpers\AbstractWidgetViewHelper;
use Newland\Toubiz\Weather\Neos\ViewHelpers\Widget\Controller\ForecastsController;

/**
 * This ViewHelper renders a forecast widget.
 */
class ForecastViewHelper extends AbstractWidgetViewHelper
{
    /**
     * @Flow\Inject()
     * @var ForecastsController
     */
    protected $controller;

    public function initializeArguments(): void
    {
        parent::initializeArguments();
        $this->registerArgument('city', 'string', 'Name of the city for the forecast', true);
        $this->registerArgument('node', NodeInterface::class, 'The current node', true);
        $this->registerArgument('days', 'integer', 'Amount of days', false, 5);
    }
}
