<?php
namespace Newland\Toubiz\Weather\Neos\ViewHelpers\Widget;

/*
 * This file is part of the "toubiz-weather-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\ContentRepository\Domain\Model\NodeInterface;
use Neos\Flow\Annotations as Flow;
use Neos\FluidAdaptor\Core\Widget\AbstractWidgetViewHelper;
use Newland\Toubiz\Weather\Neos\ViewHelpers\Widget\Controller\ForecastsController;

/**
 * This ViewHelper renders a forecast widget.
 */
class ForecastViewHelper extends AbstractWidgetViewHelper
{
    /**
     * @Flow\Inject
     * @var ForecastsController
     */
    protected $controller;

    /**
     * Render this view helper.
     *
     * @param string $city          Name of the city for the forecast.
     * @param NodeInterface $node   The current node.
     * @param int $days             Amount of days to show.
     * @return string
     */
    public function render($city, NodeInterface $node, $days = 5)
    {
        $response = $this->initiateSubRequest();
        return $response->getContent();
    }
}
