<?php

namespace Newland\Toubiz\Weather\Neos\Controller;

/*
 * This file is part of the "toubiz-weather-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\Flow\Annotations as Flow;
use Neos\Flow\Configuration\ConfigurationManager;
use Neos\Flow\Mvc\Controller\ActionController;
use Neos\Flow\Mvc\View\ViewInterface;
use Newland\Toubiz\Sync\Neos\Domain\Repository\WeatherRepository;
use Newland\Toubiz\Weather\Neos\Service\CopyrightService;

/**
 * Weathers controller.
 *
 * @Flow\Scope("singleton")
 */
class WeathersController extends ActionController
{
    /**
     * @var \Neos\ContentRepository\Domain\Model\Node
     */
    protected $node;

    /**
     * @var array
     */
    protected $properties = [];

    /**
     * @Flow\Inject
     * @var WeatherRepository
     */
    protected $weatherRepository;

    /**
     * @var CopyrightService
     * @Flow\Inject
     */
    protected $copyrightService;

    /**
     * Action initializer.
     *
     * @return void
     */
    public function initializeAction()
    {
        $this->node = $this->request->getInternalArgument('__node');
        if ($this->node->getProperties()) {
            $this->properties = $this->node->getProperties();
        }
    }

    /**
     * View initializer.
     *
     * @param ViewInterface $view
     * @return void
     */
    public function initializeView(ViewInterface $view)
    {
        $view->assignMultiple(
            [
                'node' => $this->node,
                'copyrightInfo' => $this->copyrightService->getCopyrightInfo(),
            ]
        );
    }

    /**
     * Forecast action.
     *
     * Renders a Weather forecast for a given city.
     *
     * @return void
     */
    public function forecastAction()
    {
        if (!array_key_exists('city', $this->properties)) {
            return;
        }

        $weather = $this->weatherRepository->findByCity($this->properties['city']);
        $forecast = $weather ? $weather->getForecast() : [];

        $mode = '';
        if (array_key_exists('mode', $this->properties)) {
            $mode = $this->properties['mode'];
        }
        $this->view->assignMultiple(
            [
                'forecast' => $forecast,
                'mode' => $mode,
            ]
        );
    }
}
