<?php declare(strict_types=1);

namespace Newland\Toubiz\Weather\Neos\Tests\Unit;

use Neos\Flow\Tests\FunctionalTestCase;
use Newland\Toubiz\Sync\Neos\Tests\Factory\WeatherFactory;
use Newland\Toubiz\Weather\Neos\DataSource\CitiesDataSource;

class CitiesDataSourceTest extends FunctionalTestCase
{
    protected static $testablePersistenceEnabled = true;

    /** @var CitiesDataSource */
    protected $subject;

    /** @var WeatherFactory */
    protected $factory;

    public function setUp(): void
    {
        parent::setUp();
        $this->subject = $this->objectManager->get(CitiesDataSource::class);
        $this->factory = new WeatherFactory($this->objectManager);
    }

    public function testFindsAllLocationNames(): void
    {
        $this->factory->create([ 'location' => 'foo' ]);
        $this->factory->create([ 'location' => 'foo' ]);
        $this->factory->create([ 'location' => 'bar' ]);

        $data = $this->subject->getData(null);
        $this->assertCount(2, $data);
        $this->assertContains('foo', array_column($data, 'value'));
        $this->assertContains('bar', array_column($data, 'value'));
    }
}
