# Toubiz weather package for Neos CMS.
This package provides weather information.


## Integration
Add the package to your project's `composer.json` and, to ensure proper loading order of configurations, also to your site package's `composer.json`.

To build/update the weather information, run `php flow weather:synchronize`. On server environments, you'd want to add a cronjob line that executes `FLOW_CONTEXT=Production php flow weather:synchronize`.


## Customization

### Custom forecast rendering.
In order to implement a custom rendering (e.g. for a quick-info-bar that consists of multiple plugin outputs), you need to provide the required properties in your fusion instantiation. Example:
```
prototype(Newland.MyTheme:QuickInfo) < prototype(Neos.Neos:Content) {
  weatherForecast = Newland.Toubiz.Weather.Neos:Forecast {
    mode = 'oneDayTeaser'
    city = 'My City'
  }
}
```

If you want to completely override the template, you can also add `templatePath = 'resource://Newland.MyTheme/Path/To/Template.html'`.
