<?php

namespace Newland\Toubiz\Weather\Neos\ViewHelpers\Widget\Controller;

/*
 * This file is part of the "toubiz-weather-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\ContentRepository\Domain\Model\Node;
use Neos\Eel\FlowQuery\FlowQuery;
use Neos\Flow\Annotations as Flow;
use Neos\FluidAdaptor\Core\Widget\AbstractWidgetController;
use Neos\Neos\Domain\Service\ContentContext;
use Newland\Toubiz\Sync\Neos\Domain\Repository\WeatherRepository;
use Newland\Toubiz\Sync\Neos\Service\Weather\CopyrightService;

/**
 * The widget controller for the forecast widget.
 */
class ForecastsController extends AbstractWidgetController
{
    /**
     * @Flow\Inject()
     * @var WeatherRepository
     */
    protected $weatherRepository;

    /**
     * @var CopyrightService
     * @Flow\Inject()
     */
    protected $copyrightService;

    /**
     * Main action for this widget.
     *
     * @return void
     */
    public function indexAction(): void
    {
        $this->view->assignMultiple(
            [
                'node' => $this->widgetConfiguration['node'],
                'forecast' => $this->getRelevantForecast(),
                'targetNode' => $this->getTargetNode(),
                'copyrightInfo' => $this->copyrightService->getCopyrightInfo(),
                'dataProvider' => $this->widgetConfiguration['dataProvider'],
            ]
        );
    }

    /**
     * Finds the page node type that contains the forecast
     * plugin for the same city this widget is rendering.
     *
     * @return Node|null
     */
    protected function getTargetNode(): ?Node
    {
        /** @var Node $node */
        $node = $this->widgetConfiguration['node'];
        $context = $node->getContext();

        if (!$context instanceof ContentContext) {
            return null;
        }

        $site = $context->getCurrentSiteNode();

        return (new FlowQuery([ $site ]))->find(
            '[instanceof Newland.Toubiz.Weather.Neos:Forecast][city *= "' . $this->widgetConfiguration['city'] . '"]'
        )
            ->parents('[instanceof Neos.NodeTypes:Page]')
            ->get(0);
    }

    /**
     * @return array
     */
    private function getRelevantForecast(): array
    {
        $weather = $this->weatherRepository->findOneByLocation($this->widgetConfiguration['city']);
        $forecast = $weather ? $weather->getForecast() : [];
        $relevantForecast = \array_slice($forecast, 0, $this->widgetConfiguration['days']);

        return $relevantForecast;
    }
}
