<?php
namespace Newland\Toubiz\Weather\Neos\ViewHelpers\Icon;

/*
 * This file is part of the "toubiz-weather-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\FluidAdaptor\Core\ViewHelper\AbstractViewHelper;

/**
 * Weather icon view helper.
 */
class WeatherViewHelper extends AbstractViewHelper
{
    public function render(string $id, string $source, string $class = ''): string
    {
        if ($source === 'meteotest') {
            return $this->meteotestIcon($id, $class);
        }

        if ($source === 'openweathermap') {
            return $this->openweathermapIcon($id, $class);
        }

        return '';
    }

    protected function meteotestIcon(string $id, string $class): string
    {
        switch ($id) {
            case '1':
                $name = 'sunny';
                break;

            case '2':
                $name = 'mostly-sunny';
                break;

            case '3':
                $name = 'cloudy';
                break;

            case '4':
                $name = 'heavy-clouds';
                break;

            case '5':
            case '13':
                $name = 'thunderstorm';
                break;

            case '6':
                $name = 'heavy-rain';
                break;

            case '7':
            case '9':
            case '12':
            case '15':
                $name = 'snow';
                break;

            case '8':
            case '14':
                $name = 'fog';
                break;

            case '10':
            case '11':
                $name = 'rain';
                break;
        }

        if (isset($name)) {
            return '<svg class="' . $class . '"><use xlink:href="#icon-weather-' . $name . '"></use></svg>';
        }

        return '';
    }

    protected function openweathermapIcon(string $id, string $class): string
    {
        return '<svg class="' . $class . '"><use xlink:href="#icon-weather-' . $id . '"></use></svg>';
    }
}
