<?php declare(strict_types=1);

namespace Newland\Toubiz\Weather\Neos\Tests\Integration;

use Newland\NeosTestingHelpers\IntegrationTestCase;
use Newland\Toubiz\Sync\Neos\Tests\Factory\WeatherFactory;

class ForecastTest extends IntegrationTestCase
{

    /** @var WeatherFactory */
    protected $factory;

    public function setUp(): void
    {
        parent::setUp();
        $this->factory = new WeatherFactory($this->objectManager);

        $this->node->setNodeType($this->nodeTypeManager->getNodeType('Newland.Toubiz.Weather.Neos:Forecast'));
        $this->persistNode($this->node);
    }

    /** @dataProvider provideModes */
    public function testDisplaysForecast(string $mode): void
    {
        $this->factory->create([ 'location' => 'foobar' ]);
        $this->node->setProperty('mode', $mode);
        $this->node->setProperty('city', 'foobar');
        $this->persistNode($this->node);

        $response = $this->browser->request($this->nodeUri);
        $this->assertResponseOk($response);
    }

    public function provideModes(): array
    {
        return [
            [ 'fullForecast' ],
            [ 'oneDayTeaser' ],
            [ 'threeDayTeaser' ],
        ];
    }

}
