<?php
namespace Newland\Toubiz\Weather\Neos\DataSource;

/*
 * This file is part of the "toubiz-weather-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\ContentRepository\Domain\Model\NodeInterface;
use Neos\Flow\Annotations as Flow;
use Neos\Neos\Service\DataSource\AbstractDataSource;
use Newland\Toubiz\Sync\Neos\Domain\Repository\WeatherRepository;

/**
 * Cities data source service.
 *
 * @Flow\Scope("singleton")
 */
class CitiesDataSource extends AbstractDataSource
{
    /**
     * @var string Data source identifier.
     */
    protected static $identifier = 'newland-toubiz-weather-neos-cities';

    /**
     * @Flow\Inject()
     * @var WeatherRepository
     */
    protected $weatherRepository;

    /**
     * Get requested data from source.
     *
     * The return value must be JSON serializable data structure.
     *
     * @api
     * @param NodeInterface $node The node that is currently edited (optional)
     * @param array $arguments Additional arguments (key / value)
     * @return mixed JSON serializable data
     */
    public function getData(NodeInterface $node = null, array $arguments = [])
    {
        $cities = $this->weatherRepository->findAllCities();

        $data = [];
        foreach ($cities as $city) {
            $data[] = [
                'label' => $city,
                'value' => $city,
            ];
        }

        sort($data);
        return $data;
    }
}
