<?php
namespace Newland\Toubiz\Weather\Neos\ViewHelpers\Widget\Controller;

/*
 * This file is part of the "toubiz-weather-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\ContentRepository\Domain\Model\Node;
use Neos\Eel\FlowQuery\FlowQuery;
use Neos\Flow\Annotations as Flow;
use Neos\FluidAdaptor\Core\Widget\AbstractWidgetController;
use Neos\ContentRepository\Domain\Model\NodeInterface;
use Newland\Toubiz\Sync\Neos\Domain\Repository\WeatherRepository;

/**
 * The widget controller for the forecast widget.
 */
class ForecastsController extends AbstractWidgetController
{
    /**
     * @Flow\Inject
     * @var WeatherRepository
     */
    protected $weatherRepository;

    /**
     * Main action for this widget.
     *
     * @return void
     */
    public function indexAction()
    {
        $this->view->assign('node', $this->widgetConfiguration['node']);

        $forecast = $this->weatherRepository->findByCity(
            $this->widgetConfiguration['city']
        );
        $this->view->assign(
            'forecast',
            array_slice($forecast, 0, $this->widgetConfiguration['days'])
        );

        $targetNode = $this->getTargetNode();
        if ($targetNode) {
            $this->view->assign('targetNode', $targetNode);
        }
    }

    /**
     * Finds the page node type that contains the forecast
     * plugin for the same city this widget is rendering.
     *
     * @return Node|null
     */
    protected function getTargetNode()
    {
        $site = $this->widgetConfiguration['node']->getContext()->getCurrentSiteNode();

        $query = new FlowQuery([$site]);
        return $query->find('[instanceof Newland.Toubiz.Weather.Neos:Forecast][city *= "' . $this->widgetConfiguration['city'] . '"]')
                     ->parents('[instanceof Neos.NodeTypes:Page]')
                     ->get(0);
    }
}
