<?php declare(strict_types=1);
namespace Newland\Toubiz\Sync\Neos\Utility;

use Neos\Eel\ProtectedContextAwareInterface;
use Neos\Flow\Annotations as Flow;
use Neos\Neos\Service\TransliterationService;

class StringSanitize
{

    /**
     * @Flow\Inject()
     * @var TransliterationService
     */
    protected $transliterationService;

    public static function sanitize(string $string): string
    {
        $title = (new StringSanitize)->transliterate($string);
        $title = trim($title);
        $result = \Safe\preg_replace('/[^A-Za-z0-9\-\s]/u', '', $title);

        $result = \Safe\preg_replace('/[ \-+_]+/', '', $result);

        if (is_array($result)) {
            $result = implode('', $result);
        }
        return strtolower($result ?? '');
    }

    private function transliterate(string $string): string
    {
        return $this->transliterationService->transliterate($string);
    }
}
