<?php declare(strict_types=1);

namespace Newland\Toubiz\Sync\Neos\Tests\Unit\Utility;

use Newland\Toubiz\Sync\Neos\Utility\NumberUtility;
use PHPUnit\Framework\TestCase;

class NumberUtilityTest extends TestCase
{
    /** @dataProvider provideNumbers */
    public function testFiguresOutIf2NumbersAreWithinAGivenThreshold(float $a, float $b, float $leeway, bool $shouldBeEqual): void
    {
        if ($shouldBeEqual) {
            $message = sprintf(
                '%f should be roughly equal to %f (leeway: %f)',
                $a,
                $b,
                $leeway
            );
        } else {
            $message = sprintf(
                '%f should not be roughly equal to %f (leeway: %f)',
                $a,
                $b,
                $leeway
            );
        }

        $this->assertEquals(
            $shouldBeEqual,
            NumberUtility::roughlyEquals($a, $b, $leeway),
            $message
        );
    }

    public function provideNumbers(): array
    {
        return [
             [ 0.02, 0.03, 0.1, true ],
             [ 0.02, 0.03, 0.001, false ],
             [ 0.00040000001, 0.00039999999, 0.001, true ],
        ];
    }
}
