<?php declare(strict_types=1);

namespace Newland\Toubiz\Sync\Neos\Tests\Factory;

use Newland\Toubiz\Sync\Neos\Domain\Model\Category;

/**
 * @method Category create(array $properties = [])
 */
class CategoryFactory extends AbstractFactory
{

    public function make(array $properties = [])
    {
        $category = new Category();

        $category->setTitle($properties['title'] ?? $this->faker->name);
        $category->setOriginalId($properties['originalId'] ?? $this->faker->uuid);
        $category->setLanguage($properties['language'] ?? null);
        $category->setLanguageGrouping($properties['languageGrouping'] ?? $category->getOriginalId());

        if (array_key_exists('language', $properties)) {
            $category->setLanguage($properties['language']);
        }
        if (array_key_exists('persistenceObjectIdentifier', $properties)) {
            $category->setPersistenceObjectIdentifier($properties['persistenceObjectIdentifier']);
        }

        return $category;
    }
}
