<?php declare(strict_types=1);

namespace Newland\Toubiz\Sync\Neos\Tests\Factory;

/*
 * This file is part of the "toubiz-sync-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Newland\Toubiz\Sync\Neos\Domain\Model\Award;

class AwardFactory extends AbstractFactory
{
    public function make(array $properties = [])
    {
        $award = new Award();

        $award->setLanguage($properties['language'] ?? null);
        $award->setName($properties['name'] ?? '');
        $award->setIconName($properties['iconName'] ?? '');
        $award->setValue($properties['value'] ?? -1);
        $award->setOriginalId($properties['originalId'] ?? '');
        $award->setShowInList($properties['showInList'] ?? true);
        $award->setRelatedArticleOriginalId($properties['relatedArticleOriginalId'] ?? '');

        return $award;
    }
}
