<?php declare(strict_types=1);

/*
 * Copyright (c) 2024, land in sicht AG
 *
 * www.land-in-sicht.de - All rights reserved.
 *
 * This is proprietary software. Unauthorized copying
 * of this file, via any medium, is strictly prohibited.
 */

namespace Neos\Flow\Persistence\Doctrine\Migrations;

use Doctrine\Migrations\AbstractMigration;
use Doctrine\DBAL\Schema\Schema;

/**
 * Auto-generated Migration: Please modify to your needs! This block will be used as the migration description if
 * getDescription() is not used.
 */
class Version20240411163350 extends AbstractMigration
{
    public function up(Schema $schema): void
    {
        $this->abortIf(
            $this->connection->getDatabasePlatform()->getName() != 'mysql',
            'Migration can only be executed safely on "mysql".'
        );

        $this->addSql(
            'CREATE TABLE newland_toubiz_sync_neos_domain_model_seoinformation (persistence_object_identifier CHAR(36) NOT NULL COMMENT \'(DC2Type:guid)\', ' .
            'metatitle VARCHAR(255) DEFAULT NULL, ' .
            'metadescription VARCHAR(255) DEFAULT NULL, ' .
            'noindex TINYINT(1) DEFAULT \'0\' NOT NULL, ' .
            'opengraphtitle VARCHAR(255) DEFAULT NULL, ' .
            'opengraphdescription VARCHAR(255) DEFAULT NULL, ' .
            'opengraphimage VARCHAR(255) DEFAULT NULL, ' .
            'PRIMARY KEY(persistence_object_identifier)) ' .
            'DEFAULT CHARACTER SET utf8mb4 COLLATE `utf8mb4_unicode_ci` ENGINE = InnoDB'
        );
        $this->addSql(
            'ALTER TABLE newland_toubiz_sync_neos_domain_model_article ' .
            'ADD seoinformation CHAR(36) DEFAULT NULL COMMENT \'(DC2Type:guid)\''
        );
        $this->addSql(
            'ALTER TABLE newland_toubiz_sync_neos_domain_model_article ' .
            'ADD CONSTRAINT FK_2D54DF934C51DC02 ' .
            'FOREIGN KEY (seoinformation) ' .
            'REFERENCES newland_toubiz_sync_neos_domain_model_seoinformation (persistence_object_identifier)'
        );
        $this->addSql(
            'CREATE UNIQUE INDEX UNIQ_2D54DF934C51DC02 ON newland_toubiz_sync_neos_domain_model_article (seoinformation)'
        );
        $this->addSql(
            'ALTER TABLE newland_toubiz_sync_neos_domain_model_event ' .
            'ADD seoinformation CHAR(36) DEFAULT NULL COMMENT \'(DC2Type:guid)\''
        );
        $this->addSql(
            'ALTER TABLE newland_toubiz_sync_neos_domain_model_event ' .
            'ADD CONSTRAINT FK_4DAD30E64C51DC02 ' .
            'FOREIGN KEY (seoinformation) ' .
            'REFERENCES newland_toubiz_sync_neos_domain_model_seoinformation (persistence_object_identifier)'
        );
        $this->addSql(
            'CREATE UNIQUE INDEX UNIQ_4DAD30E64C51DC02 ON newland_toubiz_sync_neos_domain_model_event (seoinformation)'
        );
    }

    public function down(Schema $schema)
    {
        $this->abortIf(
            $this->connection->getDatabasePlatform()->getName() != 'mysql',
            'Migration can only be executed safely on "mysql".'
        );

        $this->addSql('ALTER TABLE newland_toubiz_sync_neos_domain_model_article DROP FOREIGN KEY FK_2D54DF934C51DC02');
        $this->addSql('ALTER TABLE newland_toubiz_sync_neos_domain_model_event DROP FOREIGN KEY FK_4DAD30E64C51DC02');
        $this->addSql('DROP TABLE newland_toubiz_sync_neos_domain_model_seoinformation');
        $this->addSql('DROP INDEX UNIQ_2D54DF934C51DC02 ON newland_toubiz_sync_neos_domain_model_article');
        $this->addSql('ALTER TABLE newland_toubiz_sync_neos_domain_model_article DROP seoinformation');
        $this->addSql('DROP INDEX UNIQ_4DAD30E64C51DC02 ON newland_toubiz_sync_neos_domain_model_event');
        $this->addSql('ALTER TABLE newland_toubiz_sync_neos_domain_model_event DROP seoinformation');
    }
}
