<?php
namespace Neos\Flow\Persistence\Doctrine\Migrations;

use Doctrine\Migrations\AbstractMigration;
use Doctrine\DBAL\Schema\Schema;

class Version20200727133005 extends AbstractMigration
{

    public function up(Schema $schema): void
    {
        $this->abortIf($this->connection->getDatabasePlatform()->getName() != 'mysql', 'Migration can only be executed safely on "mysql".');

        $this->addSql('CREATE TABLE newland_toubiz_sync_neos_domain_model_article_awards_join (neos_article CHAR(36) NOT NULL COMMENT \'(DC2Type:guid)\', neos_award CHAR(36) NOT NULL COMMENT \'(DC2Type:guid)\', INDEX IDX_1016901E61A7D39C (neos_article), INDEX IDX_1016901E5FBA8327 (neos_award), PRIMARY KEY(neos_article, neos_award)) DEFAULT CHARACTER SET utf8mb4 COLLATE `utf8mb4_unicode_ci` ENGINE = InnoDB');
        $this->addSql('ALTER TABLE newland_toubiz_sync_neos_domain_model_article_awards_join ADD CONSTRAINT FK_1016901E61A7D39C FOREIGN KEY (neos_article) REFERENCES newland_toubiz_sync_neos_domain_model_article (persistence_object_identifier)');
        $this->addSql('ALTER TABLE newland_toubiz_sync_neos_domain_model_article_awards_join ADD CONSTRAINT FK_1016901E5FBA8327 FOREIGN KEY (neos_award) REFERENCES newland_toubiz_sync_neos_domain_model_award (persistence_object_identifier)');
        $this->addSql('ALTER TABLE newland_toubiz_sync_neos_domain_model_award DROP FOREIGN KEY FK_FC5814A623A0E66');
        $this->addSql('DROP INDEX IDX_FC5814A623A0E66 ON newland_toubiz_sync_neos_domain_model_award');
        $this->addSql('ALTER TABLE newland_toubiz_sync_neos_domain_model_award DROP article');
    }

    public function down(Schema $schema): void
    {
        $this->abortIf($this->connection->getDatabasePlatform()->getName() != 'mysql', 'Migration can only be executed safely on "mysql".');

        $this->addSql('DROP TABLE newland_toubiz_sync_neos_domain_model_article_awards_join');
        $this->addSql('ALTER TABLE newland_toubiz_sync_neos_domain_model_award ADD article CHAR(36) CHARACTER SET utf8mb4 DEFAULT NULL COLLATE `utf8mb4_unicode_ci` COMMENT \'(DC2Type:guid)\'');
        $this->addSql('ALTER TABLE newland_toubiz_sync_neos_domain_model_award ADD CONSTRAINT FK_FC5814A623A0E66 FOREIGN KEY (article) REFERENCES newland_toubiz_sync_neos_domain_model_article (persistence_object_identifier)');
        $this->addSql('CREATE INDEX IDX_FC5814A623A0E66 ON newland_toubiz_sync_neos_domain_model_award (article)');
    }
}
