<?php
namespace Neos\Flow\Persistence\Doctrine\Migrations;

use Doctrine\Migrations\AbstractMigration;
use Doctrine\DBAL\Schema\Schema;

class Version20190606065312 extends AbstractMigration
{

    public function isTransactional()
    {
        return false;
    }

    /**
     * @param Schema $schema
     * @return void
     */
    public function up(Schema $schema)
    {
        // this up() migration is autogenerated, please modify it to your needs
        $this->abortIf(
            $this->connection->getDatabasePlatform()->getName() != 'mysql',
            'Migration can only be executed safely on "mysql".'
        );

        $this->addSql(
            'CREATE TABLE IF NOT EXISTS newland_toubiz_sync_neos_domain_model_attribute (persistence_object_identifier VARCHAR(40) NOT NULL, article VARCHAR(40) DEFAULT NULL, name VARCHAR(255) NOT NULL, data LONGTEXT DEFAULT NULL, type VARCHAR(10) DEFAULT NULL, identificationhash VARCHAR(32) DEFAULT NULL, INDEX IDX_6265372F23A0E66 (article), INDEX identificationHash (identificationHash), PRIMARY KEY(persistence_object_identifier)) DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci ENGINE = InnoDB'
        );
        $this->addSql(
            'CREATE TABLE IF NOT EXISTS newland_toubiz_sync_neos_domain_model_geometry (persistence_object_identifier VARCHAR(40) NOT NULL, type VARCHAR(255) NOT NULL, label VARCHAR(255) NOT NULL, geometry GEOMETRY NOT NULL COMMENT \'(DC2Type:geometry)\', PRIMARY KEY(persistence_object_identifier)) DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci ENGINE = InnoDB'
        );
        $this->addSql(
            'CREATE TABLE IF NOT EXISTS newland_toubiz_sync_neos_domain_model_keyvalue (persistence_object_identifier VARCHAR(40) NOT NULL, identifier VARCHAR(255) NOT NULL, data LONGTEXT NOT NULL, INDEX newland_toubiz_sync_neos_keyvalue_identifier (identifier), PRIMARY KEY(persistence_object_identifier)) DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci ENGINE = InnoDB'
        );
        $this->addSql(
            'CREATE TABLE IF NOT EXISTS newland_toubiz_sync_neos_domain_model_address (persistence_object_identifier VARCHAR(40) NOT NULL, name VARCHAR(255) DEFAULT NULL, firstname VARCHAR(255) DEFAULT NULL, lastname VARCHAR(255) DEFAULT NULL, street VARCHAR(255) DEFAULT NULL, zip VARCHAR(255) DEFAULT NULL, city VARCHAR(255) DEFAULT NULL, country VARCHAR(255) DEFAULT NULL, phonenumber VARCHAR(255) DEFAULT NULL, emailaddress VARCHAR(255) DEFAULT NULL, websiteaddress LONGTEXT DEFAULT NULL, latitude DOUBLE PRECISION DEFAULT NULL, longitude DOUBLE PRECISION DEFAULT NULL, originalid VARCHAR(50) NOT NULL, INDEX newland_toubiz_sync_neos_address_import_ident (originalid), PRIMARY KEY(persistence_object_identifier)) DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci ENGINE = InnoDB'
        );
        $this->addSql(
            'CREATE TABLE IF NOT EXISTS newland_toubiz_sync_neos_domain_model_article (persistence_object_identifier VARCHAR(40) NOT NULL, mainaddress VARCHAR(40) DEFAULT NULL, maintype INT NOT NULL, name VARCHAR(255) NOT NULL, abstract LONGTEXT DEFAULT NULL, description LONGTEXT DEFAULT NULL, facebookuri VARCHAR(255) DEFAULT NULL, twitteruri VARCHAR(255) DEFAULT NULL, instagramuri VARCHAR(255) DEFAULT NULL, youtubeuri VARCHAR(255) DEFAULT NULL, flickruri VARCHAR(255) DEFAULT NULL, wikipediauri VARCHAR(255) DEFAULT NULL, sourcename VARCHAR(255) DEFAULT NULL, authorname VARCHAR(255) DEFAULT NULL, bookinguri VARCHAR(255) DEFAULT NULL, client VARCHAR(255) DEFAULT NULL, detailuri VARCHAR(255) DEFAULT NULL, starclassification SMALLINT DEFAULT NULL, averagerating SMALLINT DEFAULT NULL, numberofratings SMALLINT DEFAULT NULL, updatedat DATETIME DEFAULT NULL, openingtimes LONGTEXT DEFAULT NULL, openingtimesformat VARCHAR(255) DEFAULT NULL, originalid VARCHAR(50) NOT NULL, relationsorting LONGTEXT DEFAULT NULL COMMENT \'(DC2Type:array)\', language CHAR(2) DEFAULT NULL, urlidentifier VARCHAR(10) DEFAULT NULL, UNIQUE INDEX UNIQ_2D54DF93AEB4799D (urlidentifier), INDEX IDX_2D54DF936B613014 (mainaddress), INDEX newland_toubiz_sync_neos_article_import_ident (language, originalid), PRIMARY KEY(persistence_object_identifier)) DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci ENGINE = InnoDB'
        );
        $this->addSql(
            'CREATE TABLE IF NOT EXISTS newland_toubiz_sync_neos_domain_model_article_addresses_join (neos_article VARCHAR(40) NOT NULL, neos_address VARCHAR(40) NOT NULL, INDEX IDX_C2F8B1C461A7D39C (neos_article), INDEX IDX_C2F8B1C46ED3B27B (neos_address), PRIMARY KEY(neos_article, neos_address)) DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci ENGINE = InnoDB'
        );
        $this->addSql(
            'CREATE TABLE IF NOT EXISTS newland_toubiz_sync_neos_domain_model_article_categories_join (neos_article VARCHAR(40) NOT NULL, neos_category VARCHAR(40) NOT NULL, INDEX IDX_40F8B83C61A7D39C (neos_article), INDEX IDX_40F8B83C5B479F1E (neos_category), PRIMARY KEY(neos_article, neos_category)) DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci ENGINE = InnoDB'
        );
        $this->addSql(
            'CREATE TABLE IF NOT EXISTS newland_toubiz_sync_neos_domain_model_article_media_join (neos_article VARCHAR(40) NOT NULL, neos_medium VARCHAR(40) NOT NULL, INDEX IDX_2B4FD31061A7D39C (neos_article), INDEX IDX_2B4FD3105DC266AA (neos_medium), PRIMARY KEY(neos_article, neos_medium)) DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci ENGINE = InnoDB'
        );
        $this->addSql(
            'CREATE TABLE IF NOT EXISTS newland_toubiz_sync_neos_domain_model_article_files_join (neos_article VARCHAR(40) NOT NULL, neos_file VARCHAR(40) NOT NULL, INDEX IDX_6FC009A261A7D39C (neos_article), INDEX IDX_6FC009A2D731232 (neos_file), PRIMARY KEY(neos_article, neos_file)) DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci ENGINE = InnoDB'
        );
        $this->addSql(
            'CREATE TABLE IF NOT EXISTS newland_toubiz_sync_neos_domain_model_benefit (persistence_object_identifier VARCHAR(40) NOT NULL, package VARCHAR(40) DEFAULT NULL, name VARCHAR(255) NOT NULL, originalid VARCHAR(50) NOT NULL, INDEX IDX_73E5D1EADE686795 (package), INDEX newland_toubiz_sync_neos_benefit_import_ident (originalid), PRIMARY KEY(persistence_object_identifier)) DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci ENGINE = InnoDB'
        );
        $this->addSql(
            'CREATE TABLE IF NOT EXISTS newland_toubiz_sync_neos_domain_model_category (persistence_object_identifier VARCHAR(40) NOT NULL, title VARCHAR(255) NOT NULL, originalid VARCHAR(50) NOT NULL, language CHAR(2) DEFAULT NULL, INDEX newland_toubiz_sync_neos_category_import_ident (language, originalid), PRIMARY KEY(persistence_object_identifier)) DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci ENGINE = InnoDB'
        );
        $this->addSql(
            'CREATE TABLE IF NOT EXISTS newland_toubiz_sync_neos_domain_model_event (persistence_object_identifier VARCHAR(40) NOT NULL, location VARCHAR(40) DEFAULT NULL, organizer VARCHAR(40) DEFAULT NULL, title VARCHAR(255) NOT NULL, description LONGTEXT DEFAULT NULL, additionalinformation LONGTEXT DEFAULT NULL, admission LONGTEXT DEFAULT NULL, ishighlight TINYINT(1) NOT NULL, istipp TINYINT(1) NOT NULL, beginsat DATETIME NOT NULL, endsat DATETIME NOT NULL, ticketuri LONGTEXT DEFAULT NULL, ticketcontact LONGTEXT DEFAULT NULL, link LONGTEXT DEFAULT NULL, updatedat DATETIME NOT NULL, sourcename VARCHAR(255) DEFAULT NULL, attributes LONGTEXT DEFAULT NULL COMMENT \'(DC2Type:array)\', scope SMALLINT DEFAULT NULL, originalid VARCHAR(50) NOT NULL, language CHAR(2) DEFAULT NULL, urlidentifier VARCHAR(10) DEFAULT NULL, UNIQUE INDEX UNIQ_4DAD30E6AEB4799D (urlidentifier), INDEX IDX_4DAD30E65E9E89CB (location), INDEX IDX_4DAD30E699D47173 (organizer), INDEX newland_toubiz_sync_neos_event_import_ident (language, originalid), PRIMARY KEY(persistence_object_identifier)) DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci ENGINE = InnoDB'
        );
        $this->addSql(
            'CREATE TABLE IF NOT EXISTS newland_toubiz_sync_neos_domain_model_event_categories_join (neos_event VARCHAR(40) NOT NULL, neos_category VARCHAR(40) NOT NULL, INDEX IDX_744FD94FEE4FA767 (neos_event), INDEX IDX_744FD94F5B479F1E (neos_category), PRIMARY KEY(neos_event, neos_category)) DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci ENGINE = InnoDB'
        );
        $this->addSql(
            'CREATE TABLE IF NOT EXISTS newland_toubiz_sync_neos_domain_model_event_eventtags_join (neos_event VARCHAR(40) NOT NULL, neos_eventtag VARCHAR(40) NOT NULL, INDEX IDX_ECF21824EE4FA767 (neos_event), INDEX IDX_ECF2182449341CE7 (neos_eventtag), PRIMARY KEY(neos_event, neos_eventtag)) DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci ENGINE = InnoDB'
        );
        $this->addSql(
            'CREATE TABLE IF NOT EXISTS newland_toubiz_sync_neos_domain_model_event_media_join (neos_event VARCHAR(40) NOT NULL, neos_medium VARCHAR(40) NOT NULL, INDEX IDX_886DAE27EE4FA767 (neos_event), INDEX IDX_886DAE275DC266AA (neos_medium), PRIMARY KEY(neos_event, neos_medium)) DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci ENGINE = InnoDB'
        );
        $this->addSql(
            'CREATE TABLE IF NOT EXISTS newland_toubiz_sync_neos_domain_model_eventdate (persistence_object_identifier VARCHAR(40) NOT NULL, event VARCHAR(40) DEFAULT NULL, beginsat DATETIME NOT NULL, endsat DATETIME NOT NULL, note VARCHAR(255) NOT NULL, detailuri VARCHAR(255) DEFAULT NULL, originalid VARCHAR(50) NOT NULL, language CHAR(2) DEFAULT NULL, INDEX IDX_6E2533873BAE0AA7 (event), INDEX newland_toubiz_sync_neos_eventdate_import_ident (language, originalid), PRIMARY KEY(persistence_object_identifier)) DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci ENGINE = InnoDB'
        );
        $this->addSql(
            'CREATE TABLE IF NOT EXISTS newland_toubiz_sync_neos_domain_model_eventtag (persistence_object_identifier VARCHAR(40) NOT NULL, keyword LONGTEXT NOT NULL, originalid VARCHAR(50) NOT NULL, language CHAR(2) DEFAULT NULL, INDEX newland_toubiz_sync_neos_eventtag_import_ident (language, originalid), PRIMARY KEY(persistence_object_identifier)) DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci ENGINE = InnoDB'
        );
        $this->addSql(
            'CREATE TABLE IF NOT EXISTS newland_toubiz_sync_neos_domain_model_file (persistence_object_identifier VARCHAR(40) NOT NULL, name VARCHAR(255) NOT NULL, sourceuri LONGTEXT NOT NULL, originalid VARCHAR(50) NOT NULL, INDEX newland_toubiz_sync_neos_file_import_ident (originalid), PRIMARY KEY(persistence_object_identifier)) DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci ENGINE = InnoDB'
        );
        $this->addSql(
            'CREATE TABLE IF NOT EXISTS newland_toubiz_sync_neos_domain_model_medium (persistence_object_identifier VARCHAR(40) NOT NULL, title LONGTEXT DEFAULT NULL, sourceuri LONGTEXT NOT NULL, copyright VARCHAR(255) DEFAULT NULL, sorting INT DEFAULT NULL, originalid VARCHAR(50) NOT NULL, INDEX newland_toubiz_sync_neos_medium_import_ident (originalid), PRIMARY KEY(persistence_object_identifier)) DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci ENGINE = InnoDB'
        );
        $this->addSql(
            'CREATE TABLE IF NOT EXISTS newland_toubiz_sync_neos_domain_model_offer (persistence_object_identifier VARCHAR(40) NOT NULL, name VARCHAR(255) NOT NULL, previewimage VARCHAR(255) DEFAULT NULL, startingprice DOUBLE PRECISION DEFAULT NULL, startingpricecurrency CHAR(3) DEFAULT NULL, durationminutes INT DEFAULT NULL, address VARCHAR(255) DEFAULT NULL, originalid VARCHAR(50) NOT NULL, INDEX newland_toubiz_sync_neos_offer_import_ident (originalid), PRIMARY KEY(persistence_object_identifier)) DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci ENGINE = InnoDB'
        );
        $this->addSql(
            'CREATE TABLE IF NOT EXISTS newland_toubiz_sync_neos_domain_model_package (persistence_object_identifier VARCHAR(40) NOT NULL, name VARCHAR(255) NOT NULL, minimumnights DOUBLE PRECISION DEFAULT NULL, startingprice DOUBLE PRECISION DEFAULT NULL, startingpricecurrency CHAR(3) DEFAULT NULL, client VARCHAR(255) NOT NULL, originalid VARCHAR(50) NOT NULL, INDEX newland_toubiz_sync_neos_package_import_ident (originalid), PRIMARY KEY(persistence_object_identifier)) DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci ENGINE = InnoDB'
        );
        $this->addSql(
            'CREATE TABLE IF NOT EXISTS newland_toubiz_sync_neos_domain_model_package_media_join (neos_package VARCHAR(40) NOT NULL, neos_medium VARCHAR(40) NOT NULL, INDEX IDX_1B8AF764BDF5BA6F (neos_package), INDEX IDX_1B8AF7645DC266AA (neos_medium), PRIMARY KEY(neos_package, neos_medium)) DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci ENGINE = InnoDB'
        );
        $this->addSql(
            'CREATE TABLE IF NOT EXISTS newland_toubiz_sync_neos_domain_model_region (persistence_object_identifier VARCHAR(40) NOT NULL, name VARCHAR(255) NOT NULL, attributes LONGTEXT DEFAULT NULL COMMENT \'(DC2Type:array)\', updatedat DATETIME DEFAULT NULL, originalid VARCHAR(50) NOT NULL, INDEX newland_toubiz_sync_neos_region_import_ident (originalid), PRIMARY KEY(persistence_object_identifier)) DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci ENGINE = InnoDB'
        );
        $this->addSql(
            'CREATE TABLE IF NOT EXISTS newland_toubiz_sync_neos_region_transportation_facilities_join (neos_region VARCHAR(40) NOT NULL, neos_transportationfacility VARCHAR(40) NOT NULL, INDEX IDX_3349FAD194D3D26B (neos_region), INDEX IDX_3349FAD1E580DEF8 (neos_transportationfacility), PRIMARY KEY(neos_region, neos_transportationfacility)) DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci ENGINE = InnoDB'
        );
        $this->addSql(
            'CREATE TABLE IF NOT EXISTS newland_toubiz_sync_neos_region_slopes_join (neos_region VARCHAR(40) NOT NULL, neos_slope VARCHAR(40) NOT NULL, INDEX IDX_9603E59694D3D26B (neos_region), INDEX IDX_9603E5968D2DE845 (neos_slope), PRIMARY KEY(neos_region, neos_slope)) DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci ENGINE = InnoDB'
        );
        $this->addSql(
            'CREATE TABLE IF NOT EXISTS newland_toubiz_sync_neos_domain_model_slope (persistence_object_identifier VARCHAR(40) NOT NULL, name VARCHAR(255) NOT NULL, status INT NOT NULL, type INT DEFAULT NULL, difficulty INT DEFAULT NULL, updatedat DATETIME NOT NULL, originalid VARCHAR(50) NOT NULL, INDEX newland_toubiz_sync_neos_slope_import_ident (originalid), PRIMARY KEY(persistence_object_identifier)) DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci ENGINE = InnoDB'
        );
        $this->addSql(
            'CREATE TABLE IF NOT EXISTS newland_toubiz_sync_neos_domain_model_transportationfacility (persistence_object_identifier VARCHAR(40) NOT NULL, name VARCHAR(255) NOT NULL, type INT NOT NULL, status INT NOT NULL, length INT DEFAULT NULL, traveltime INT DEFAULT NULL, updatedat DATETIME NOT NULL, originalid VARCHAR(50) NOT NULL, INDEX newland_toubiz_sync_neos_transportationfacility_import_ident (originalid), PRIMARY KEY(persistence_object_identifier)) DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci ENGINE = InnoDB'
        );
    }

    /**
     * @param Schema $schema
     * @return void
     */
    public function down(Schema $schema)
    {
        // this down() migration is autogenerated, please modify it to your needs
        $this->abortIf(true, 'Migration is not revertable');
    }

}