<?php
namespace Newland\Toubiz\Sync\Neos\Translation;

use Doctrine\ORM\Mapping as ORM;
use Newland\Toubiz\Api\Constants\Language;

trait TranslatableEntity
{

    /**
     * @var string|null
     * @ORM\Column(type="string", options={"fixed" = true}, length=2, nullable=true)
     */
    protected $language;

    /**
     * @var string|null
     * @ORM\Column(type="string", nullable=true)
     */
    protected $languageGrouping;

    public function getLanguage(): ?string
    {
        return $this->language;
    }

    public function setLanguage(string $language = null): void
    {
        if ($language) {
            Language::throwIfInvalid($language);
        }
        $this->language = $language;
    }

    public function getLanguageGrouping(): ?string
    {
        return $this->languageGrouping;
    }

    public function setLanguageGrouping(?string $languageGrouping): void
    {
        $this->languageGrouping = $languageGrouping;
    }
}
