<?php declare(strict_types=1);


namespace Newland\Toubiz\Sync\Neos\Domain\Model\Traits;

use Doctrine\ORM\Mapping as ORM;
use Ramsey\Uuid\UuidInterface;

trait PersistenceObjectIdentifier
{

    /**
     * @ORM\Id()
     * @ORM\GeneratedValue(strategy="CUSTOM")
     * @ORM\CustomIdGenerator(class="Newland\Toubiz\Sync\Neos\Orm\Uuid\UuidGenerator")
     * @ORM\Column(type="guid", unique=TRUE)
     * @var string|UuidInterface
     */
    protected $Persistence_Object_Identifier;

    public function getPersistenceObjectIdentifier(): ?string
    {
        if ($this->Persistence_Object_Identifier instanceof UuidInterface) {
            return $this->Persistence_Object_Identifier->toString();
        }

        return $this->Persistence_Object_Identifier;
    }

    public function setPersistenceObjectIdentifier(string $identifier): void
    {
        $this->Persistence_Object_Identifier = $identifier;
    }
}
