<?php declare(strict_types=1);

/*
 * Copyright (c) 2024, land in sicht AG
 *
 * www.land-in-sicht.de - All rights reserved.
 *
 * This is proprietary software.
 * Unauthorized copying of this file, via any medium, is strictly prohibited.
 */

namespace Newland\Toubiz\Sync\Neos\Domain\Model\Traits;

use Doctrine\ORM\Mapping as ORM;
use Newland\Toubiz\Sync\Neos\Domain\Model\SeoInformation;

trait HasSeoInformation
{
    /**
     * @ORM\OneToOne(targetEntity="Newland\Toubiz\Sync\Neos\Domain\Model\SeoInformation")
     * @var SeoInformation|null
     */
    protected $seoInformation;

    public function getSeoInformation(): ?SeoInformation
    {
        return $this->seoInformation;
    }

    public function setSeoInformation(?SeoInformation $seoInformation): void
    {
        $this->seoInformation = $seoInformation;
    }
}
